/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.model.IJSImplicitBreakpoint;
import java.net.URI;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public class JSDebugImplicitBreakpoint
extends PlatformObject
implements IJSImplicitBreakpoint {
    private final URI fileName;
    private final int lineNumber;
    private final Type type;

    public JSDebugImplicitBreakpoint(URI fileName, int lineNumber, Type type) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.type = type;
    }

    public URI getFileName() throws CoreException {
        return this.fileName;
    }

    public boolean isDebuggerKeyword() {
        return this.type == Type.DEBUGGER_KEYWORD;
    }

    public boolean isFirstLine() {
        return this.type == Type.FIRST_LINE;
    }

    public boolean isException() {
        return this.type == Type.EXCEPTION;
    }

    public boolean isWatchpoint() {
        return this.type == Type.WATCHPOINT;
    }

    public String getModelIdentifier() {
        return "com.aptana.js.debug.core";
    }

    public int getLineNumber() throws CoreException {
        return this.lineNumber;
    }

    public int getCharStart() throws CoreException {
        return -1;
    }

    public int getCharEnd() throws CoreException {
        return -1;
    }

    public void setMarker(IMarker marker) throws CoreException {
    }

    public boolean equals(Object item) {
        if (item instanceof JSDebugImplicitBreakpoint) {
            return this.fileName.equals(((JSDebugImplicitBreakpoint)item).fileName) && this.lineNumber == ((JSDebugImplicitBreakpoint)item).lineNumber;
        }
        return false;
    }

    public int hashCode() {
        return (this.fileName + "\n" + this.lineNumber).hashCode();
    }

    public boolean isEnabled() throws CoreException {
        return true;
    }

    public boolean isPersisted() throws CoreException {
        return false;
    }

    public boolean isRegistered() throws CoreException {
        return false;
    }

    public void setEnabled(boolean enabled) throws CoreException {
    }

    public void setPersisted(boolean persisted) throws CoreException {
    }

    public void setRegistered(boolean registered) throws CoreException {
    }

    public void delete() throws CoreException {
    }

    public IMarker getMarker() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        DEBUGGER_KEYWORD,
        FIRST_LINE,
        EXCEPTION,
        WATCHPOINT;

    }
}

